package ru.yandex.function;

import java.util.function.Predicate;

// Overloads default and, negate and or methods, so they return predicates
// which have properly defined equals and hashCode methods
// XXX: Should we throw bad cast on non-equalable predicates passed?
@FunctionalInterface
public interface EqualablePredicate<T> extends Predicate<T> {
    @Override
    default Predicate<T> and(final Predicate<? super T> other) {
        return new AndPredicate<>(this, other);
    }

    @Override
    default Predicate<T> negate() {
        return new NegatePredicate<>(this);
    }

    @Override
    default Predicate<T> or(final Predicate<? super T> other) {
        return new OrPredicate<>(this, other);
    }
}

