package ru.yandex.function;

import java.util.function.Predicate;

public enum FalsePredicate implements Predicate<Object> {
    INSTANCE;

    @Override
    public boolean test(final Object o) {
        return false;
    }

    @SuppressWarnings("unchecked")
    public static <T> Predicate<T> instance() {
        return (Predicate<T>) INSTANCE;
    }

    @Override
    public Predicate<Object> and(final Predicate<Object> other) {
        return this;
    }

    @Override
    public Predicate<Object> negate() {
        return TruePredicate.INSTANCE;
    }

    @Override
    public Predicate<Object> or(final Predicate<Object> other) {
        return other;
    }
}

