package ru.yandex.function;

public class FilterProcessable<T> implements Processable<T> {
    protected final Processable<T> processable;

    public FilterProcessable(final Processable<T> processable) {
        this.processable = processable;
    }

    @Override
    public boolean isEmpty() {
        return processable.isEmpty();
    }

    @Override
    public int length() {
        return processable.length();
    }

    @Override
    public String toString() {
        return processable.toString();
    }

    @Override
    public <E extends Exception> void processWith(
        final VoidProcessor<? super T, E> processor)
        throws E
    {
        processable.processWith(processor);
    }

    @Override
    public <R, E extends Exception> R processWith(
        final Processor<? super T, R, E> processor)
        throws E
    {
        return processable.processWith(processor);
    }

    @Override
    public int transferTo(final T buf, final int off, final int len) {
        return processable.transferTo(buf, off, len);
    }
}

