package ru.yandex.function;

import java.util.function.Function;
import java.util.function.Supplier;

public class FunctionBinder<T, R> implements Supplier<R> {
    private final Function<? super T, ? extends R> function;
    private final T arg;

    public FunctionBinder(
        final Function<? super T, ? extends R> function,
        final T arg)
    {
        this.function = function;
        this.arg = arg;
    }

    @Override
    public R get() {
        return function.apply(arg);
    }
}

