package ru.yandex.function;

import java.util.function.Function;
import java.util.function.Supplier;

public class FunctionsBinder<T, R> implements Supplier<R> {
    private final Supplier<? extends Function<? super T, ? extends R>>
        functions;
    private final T arg;

    public FunctionsBinder(
        final Supplier<? extends Function<? super T, ? extends R>> functions,
        final T arg)
    {
        this.functions = functions;
        this.arg = arg;
    }

    @Override
    public R get() {
        Function<? super T, ? extends R> function = functions.get();
        if (function == null) {
            return null;
        } else {
            return function.apply(arg);
        }
    }
}

