package ru.yandex.function;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;

public class GenericAutoCloseableChain<E extends Exception>
    extends AtomicReference<GenericAutoCloseable<? extends E>>
    implements GenericAutoCloseable<E>, Serializable
{
    private static final long serialVersionUID = 0L;

    public void add(final GenericAutoCloseable<? extends E> closeable) {
        while (true) {
            GenericAutoCloseable<? extends E> current = get();
            if (current == null) {
                if (compareAndSet(null, closeable)) {
                    break;
                }
            } else {
                DuplexGenericAutoCloseable<E> duplexCloseable =
                    new DuplexGenericAutoCloseable<>(current, closeable);
                if (compareAndSet(current, duplexCloseable)) {
                    break;
                }
            }
        }
    }

    public boolean isEmpty() {
        return get() == null;
    }

    @Override
    public void close() throws E {
        GenericAutoCloseable<? extends E> closeable = getAndSet(null);
        if (closeable != null) {
            closeable.close();
        }
    }
}

