package ru.yandex.function;

public class GenericAutoCloseableHolder<
    E extends Exception,
    T extends GenericAutoCloseable<? extends E>>
    implements GenericAutoCloseable<E>
{
    private T t;

    public GenericAutoCloseableHolder() {
        this(null);
    }

    public GenericAutoCloseableHolder(final T t) {
        this.t = t;
    }

    public T get() {
        return t;
    }

    public T release() {
        return reset(null);
    }

    public T reset(final T newValue) {
        T t = this.t;
        this.t = newValue;
        return t;
    }

    @Override
    public void close() throws E {
        T t = release();
        if (t != null) {
            t.close();
        }
    }
}

