package ru.yandex.function;

import java.util.Map;

public class GenericCachingFunction<T, R, E extends Exception>
    implements GenericFunction<T, R, E>
{
    private final GenericFunction<? super T, ? extends R, ? extends E> next;
    private final Map<? super T, R> cache;

    public GenericCachingFunction(
        final GenericFunction<? super T, ? extends R, ? extends E> next,
        final Map<? super T, R> cache)
    {
        this.next = next;
        this.cache = cache;
    }

    @Override
    public R apply(final T t) throws E {
        R result = cache.get(t);
        if (result == null) {
            result = next.apply(t);
            R old = cache.putIfAbsent(t, result);
            if (old != null) {
                result = old;
            }
        }
        return result;
    }
}

