package ru.yandex.function;

@FunctionalInterface
public interface GenericConsumer<T, E extends Exception> {
    void accept(T t) throws E;

    default GenericConsumer<T, E> andThen(
        final GenericConsumer<? super T, ? extends E> after)
    {
        return new DuplexGenericConsumer<>(this, after);
    }
}

