package ru.yandex.function;

@FunctionalInterface
public interface GenericFunction<T, R, E extends Exception> {
    GenericFunction<Object, Object, Exception> IDENTITY = x -> x;

    R apply(T t) throws E;

    default <V, E2 extends Exception> GenericFunction<V, R, Exception> compose(
        final GenericFunction<? super V, ? extends T, E2> before)
    {
        return (V v) -> apply(before.apply(v));
    }

    default <V, E2 extends Exception> GenericFunction<T, V, Exception> andThen(
        final GenericFunction<? super R, ? extends V, E2> after)
    {
        return (T t) -> after.apply(apply(t));
    }

    @SuppressWarnings("unchecked")
    static <T, E extends Exception> GenericFunction<T, T, E> identity() {
        return (GenericFunction<T, T, E>) IDENTITY;
    }
}

