package ru.yandex.function;

public class GenericNonThrowingCloseableAdapter<E extends Exception>
    implements GenericAutoCloseable<E>
{
    private final GenericAutoCloseable<? extends RuntimeException> closeable;

    public GenericNonThrowingCloseableAdapter(
        final GenericAutoCloseable<? extends RuntimeException> closeable)
    {
        this.closeable = closeable;
    }

    @Override
    public void close() {
        closeable.close();
    }

    @Override
    public String toString() {
        return closeable.toString();
    }
}

