package ru.yandex.function;

import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;

public enum HashMapFactory implements IntFunction<Map<Object, Object>> {
    INSTANCE;

    @Override
    public Map<Object, Object> apply(final int expectedSize) {
        return new HashMap<>(expectedSize << 1);
    }

    @SuppressWarnings("unchecked")
    public static <T, U> IntFunction<Map<T, U>> instance() {
        return (IntFunction<Map<T, U>>) (Object) INSTANCE;
    }
}

