package ru.yandex.function;

import java.util.Iterator;
import java.util.function.Supplier;

public class IteratorSupplierAdapter<T> implements Supplier<T> {
    private final Iterator<T> iter;

    public IteratorSupplierAdapter(final Iterator<T> iter) {
        this.iter = iter;
    }

    @Override
    public T get() {
        if (iter.hasNext()) {
            return iter.next();
        } else {
            return null;
        }
    }
}

