package ru.yandex.function;

import java.util.function.Predicate;

public class NegatePredicate<T> implements EqualablePredicate<T> {
    private final Predicate<? super T> predicate;

    public NegatePredicate(final Predicate<? super T> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(final T t) {
        return !predicate.test(t);
    }

    @Override
    public int hashCode() {
        return ~predicate.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        return o instanceof NegatePredicate
            && predicate.equals(((NegatePredicate) o).predicate);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('-');
        sb.append(predicate.toString());
        return new String(sb);
    }
}

