package ru.yandex.function;

import java.util.function.Consumer;

public enum NullConsumer
    implements Consumer<Object>, GenericConsumer<Object, Exception>
{
    INSTANCE;

    @Override
    public void accept(final Object o) {
    }

    @Override
    public Consumer<Object> andThen(final Consumer<Object> after) {
        return after;
    }

    @Override
    @SuppressWarnings("unchecked")
    public GenericConsumer<Object, Exception> andThen(
        final GenericConsumer<Object, ? extends Exception> after)
    {
        return (GenericConsumer<Object, Exception>) after;
    }

    @SuppressWarnings("unchecked")
    public static <T> Consumer<T> instance() {
        return (Consumer<T>) INSTANCE;
    }

    @SuppressWarnings("unchecked")
    public static <T, E extends Exception> GenericConsumer<T, E>
        genericInstance()
    {
        return (GenericConsumer<T, E>) INSTANCE;
    }
}

