package ru.yandex.function;

public class NullToDefaultFunction<T, U, E extends Exception>
    implements GenericFunction<T, U, E>
{
    private final GenericFunction<? super T, ? extends U, ? extends E> next;
    private final U defaultValue;

    public NullToDefaultFunction(
        final GenericFunction<? super T, ? extends U, ? extends E> next)
    {
        this(next, null);
    }

    public NullToDefaultFunction(
        final GenericFunction<? super T, ? extends U, ? extends E> next,
        final U defaultValue)
    {
        this.next = next;
        this.defaultValue = defaultValue;
    }

    @Override
    public U apply(final T t) throws E {
        if (t == null) {
            return defaultValue;
        } else {
            return next.apply(t);
        }
    }
}

