package ru.yandex.function;

import java.util.function.Predicate;

public class OrPredicate<T> implements EqualablePredicate<T> {
    private final Predicate<? super T> lhs;
    private final Predicate<? super T> rhs;

    public OrPredicate(
        final Predicate<? super T> lhs,
        final Predicate<? super T> rhs)
    {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public boolean test(final T t) {
        return lhs.test(t) || rhs.test(t);
    }

    @Override
    public int hashCode() {
        return lhs.hashCode() + rhs.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof OrPredicate) {
            OrPredicate<?> other = (OrPredicate<?>) o;
            return lhs.equals(other.lhs) && rhs.equals(other.rhs);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(lhs.toString());
        sb.append(" OR ");
        sb.append(rhs.toString());
        sb.append(')');
        return new String(sb);
    }
}

