package ru.yandex.function;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamProcessorAdapter
    implements Closeable, Flushable, ByteArrayVoidProcessor<IOException>
{
    private final OutputStream out;

    public OutputStreamProcessorAdapter(final OutputStream out) {
        this.out = out;
    }

    @Override
    public void process(final byte[] buf, final int off, final int len)
        throws IOException
    {
        out.write(buf, off, len);
    }

    @Override
    public void flush() throws IOException {
        out.flush();
    }

    @Override
    public void close() throws IOException {
        out.close();
    }
}

