package ru.yandex.function;

import java.util.function.LongPredicate;

public enum PddUidPredicate implements LongPredicate {
    INSTANCE;

    public static final long PDD_UID_BEGIN = 1130000000000000L;
    public static final long PDD_UID_END = 9007199254740992L;

    @Override
    public boolean test(final long uid) {
        return uid >= PDD_UID_BEGIN && uid < PDD_UID_END;
    }
}

