package ru.yandex.function;

public interface Processable<T> {
    boolean isEmpty();

    int length();

    <E extends Exception> void processWith(
        VoidProcessor<? super T, E> processor)
        throws E;

    <R, E extends Exception> R processWith(
        Processor<? super T, R, E> processor)
        throws E;

    int transferTo(T buf, int off, int len);
}

