package ru.yandex.function;

public class StringBuilderVoidProcessor<T, E extends Exception>
    extends FilterProcessable<T>
    implements VoidProcessor<StringBuilder, E>
{
    private static final char[] EMPTY_BUF = new char[0];

    private final VoidProcessor<? super char[], ? extends E> processor;
    private char[] buf = EMPTY_BUF;

    public <U extends
        Processable<T>
        & VoidProcessor<? super char[], ? extends E>>
        StringBuilderVoidProcessor(final U u)
    {
        this(u, u);
    }

    private StringBuilderVoidProcessor(
        final Processable<T> processable,
        final VoidProcessor<? super char[], ? extends E> processor)
    {
        super(processable);
        this.processor = processor;
    }

    @Override
    public void process(final StringBuilder str) throws E {
        process(str, 0, str.length());
    }

    @Override
    public void process(final StringBuilder str, final int off, final int len)
        throws E
    {
        if (buf.length < len) {
            buf = new char[Math.max(len, buf.length << 1)];
        }
        str.getChars(off, off + len, buf, 0);
        processor.process(buf, 0, len);
    }
}

