package ru.yandex.function;

public class StringProcessor<R, E extends Exception>
    extends CharArrayProcessable
    implements Processor<String, R, E>
{
    private final Processor<? super char[], ? extends R, ? extends E>
        processor;

    public StringProcessor(
        final Processor<? super char[], ? extends R, ? extends E> processor)
    {
        this.processor = processor;
    }

    @Override
    public R process(final String str) throws E {
        return process(str, 0, str.length());
    }

    @Override
    public R process(final String str, final int off, final int len)
        throws E
    {
        ensureBufCapacity(len);
        str.getChars(off, off + len, buf, 0);
        return processor.process(buf, 0, len);
    }
}

