package ru.yandex.function;

import java.util.function.Predicate;

public enum TruePredicate implements Predicate<Object> {
    INSTANCE;

    @Override
    public boolean test(final Object o) {
        return true;
    }

    @SuppressWarnings("unchecked")
    public static <T> Predicate<T> instance() {
        return (Predicate<T>) INSTANCE;
    }

    @Override
    public Predicate<Object> and(final Predicate<Object> other) {
        return other;
    }

    @Override
    public Predicate<Object> negate() {
        return FalsePredicate.INSTANCE;
    }

    @Override
    public Predicate<Object> or(final Predicate<Object> other) {
        return this;
    }
}

