package ru.yandex.io;

import java.io.ByteArrayInputStream;

import ru.yandex.function.ByteArrayProcessor;

public enum ByteArrayInputStreamFactory
    implements ByteArrayProcessor<ByteArrayInputStream, RuntimeException>
{
    INSTANCE;

    @Override
    public ByteArrayInputStream process(
        final byte[] buf,
        final int off,
        final int len)
    {
        return new ByteArrayInputStream(buf, off, len);
    }
}

