package ru.yandex.io;

import java.io.IOException;
import java.io.InputStream;

import ru.yandex.function.GenericAutoCloseableChain;

public class ChainedInputStream extends InputStream {
    private final InputStream[] inputs;
    private int pos = 0;

    public ChainedInputStream(final InputStream... inputs) {
        this.inputs = inputs;
    }

    @Override
    public void close() throws IOException {
        try (GenericAutoCloseableChain<IOException> chain =
                new GenericAutoCloseableChain<>())
        {
            for (InputStream input: inputs) {
                chain.add(new GenericCloseableAdapter<>(input));
            }
        }
    }

    @Override
    public int read() throws IOException {
        while (pos < inputs.length) {
            int read = inputs[pos].read();
            if (read == -1) {
                ++pos;
            } else {
                return read;
            }
        }
        return -1;
    }

    @Override
    public int read(final byte[] buf, final int off, final int len)
        throws IOException
    {
        while (pos < inputs.length) {
            int read = inputs[pos].read(buf, off, len);
            if (read == -1) {
                ++pos;
            } else {
                return read;
            }
        }
        return -1;
    }
}

