package ru.yandex.io;

import java.io.IOException;
import java.io.Reader;

import ru.yandex.function.GenericAutoCloseableChain;

public class ChainedReader extends Reader {
    private final Reader[] readers;
    private int pos = 0;

    public ChainedReader(final Reader... readers) {
        this.readers = readers;
    }

    @Override
    public void close() throws IOException {
        try (GenericAutoCloseableChain<IOException> chain =
                new GenericAutoCloseableChain<>())
        {
            for (Reader reader: readers) {
                chain.add(new GenericCloseableAdapter<>(reader));
            }
        }
    }

    @Override
    public int read() throws IOException {
        while (pos < readers.length) {
            int read = readers[pos].read();
            if (read == -1) {
                ++pos;
            } else {
                return read;
            }
        }
        return -1;
    }

    @Override
    public int read(final char[] buf, final int off, final int len)
        throws IOException
    {
        while (pos < readers.length) {
            int read = readers[pos].read(buf, off, len);
            if (read == -1) {
                ++pos;
            } else {
                return read;
            }
        }
        return -1;
    }
}

