package ru.yandex.io;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream extends InputStream {
    private static final int BUFFER_SIZE = 65536;

    protected long pos = 0L;
    private final InputStream in;
    private boolean open = true;

    public CountingInputStream(final InputStream in) {
        this.in = in;
    }

    public long pos() {
        return pos;
    }

    @Override
    public int available() throws IOException {
        return in.available();
    }

    @Override
    public void close() throws IOException {
        if (open) {
            open = false;
            byte[] buf = new byte[BUFFER_SIZE];
            // CSOFF: EmptyBlock
            for (int read = read(buf); read != -1; read = read(buf)) {
                // Do nothing
            }
            // CSON: EmptyBlock
            in.close();
        }
    }

    @Override
    public int read() throws IOException {
        int read = in.read();
        if (read != -1) {
            ++pos;
        }
        return read;
    }

    @Override
    public int read(final byte[] buf) throws IOException {
        return read(buf, 0, buf.length);
    }

    @Override
    public int read(final byte[] buf, final int off, final int len)
        throws IOException
    {
        int read = in.read(buf, off, len);
        if (read != -1) {
            pos += read;
        }
        return read;
    }

    @Override
    public long skip(final long n) throws IOException {
        long skip = in.skip(n);
        pos += skip;
        return skip;
    }
}

