package ru.yandex.io;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream extends OutputStream {
    protected long pos = 0L;
    private final OutputStream out;

    public CountingOutputStream(final OutputStream out) {
        this.out = out;
    }

    public long pos() {
        return pos;
    }

    @Override
    public void close() throws IOException {
        out.close();
    }

    @Override
    public void flush() throws IOException {
        out.flush();
    }

    @Override
    public void write(final int b) throws IOException {
        out.write(b);
        ++pos;
    }

    @Override
    public void write(final byte[] buf) throws IOException {
        write(buf, 0, buf.length);
    }

    @Override
    public void write(final byte[] buf, final int off, final int len)
        throws IOException
    {
        out.write(buf, off, len);
        pos += len;
    }
}

