package ru.yandex.io;

import java.io.IOException;
import java.io.Writer;

public class CountingWriter extends Writer {
    private static final String NULL = "null";
    private final Writer writer;
    private long pos = 0;

    public CountingWriter(final Writer writer) {
        this.writer = writer;
    }

    public long pos() {
        return pos;
    }

    @Override
    public Writer append(final char c) throws IOException {
        writer.append(c);
        ++pos;
        return this;
    }

    @Override
    public Writer append(final CharSequence csq) throws IOException {
        if (csq == null) {
            return append(NULL);
        } else {
            return append(csq, 0, csq.length());
        }
    }

    @Override
    public Writer append(
        final CharSequence csq,
        final int start,
        final int end)
        throws IOException
    {
        if (csq == null) {
            return append(NULL);
        } else {
            writer.append(csq, start, end);
            pos += end - start;
            return this;
        }
    }

    @Override
    public void close() throws IOException {
        writer.close();
    }

    @Override
    public void flush() throws IOException {
        writer.flush();
    }

    @Override
    public void write(final char[] cbuf) throws IOException {
        write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(final char[] cbuf, final int off, final int len)
        throws IOException
    {
        writer.write(cbuf, off, len);
        pos += len;
    }

    @Override
    public void write(final int c) throws IOException {
        writer.write(c);
        ++pos;
    }

    @Override
    public void write(final String str) throws IOException {
        write(str, 0, str.length());
    }

    @Override
    public void write(final String str, final int off, final int len)
        throws IOException
    {
        writer.write(str, off, len);
        pos += len;
    }
}

