package ru.yandex.io;

import java.io.DataOutput;
import java.io.IOException;

import ru.yandex.function.ByteArrayVoidProcessor;

public class DataOutputProcessor
    implements ByteArrayVoidProcessor<IOException>
{
    private final DataOutput out;

    public DataOutputProcessor(final DataOutput out) {
        this.out = out;
    }

    @Override
    public void process(final byte[] buf, final int off, final int len)
        throws IOException
    {
        out.write(buf, off, len);
    }
}

