package ru.yandex.io;

import java.io.IOException;
import java.io.OutputStream;

public class ExceptionHandlingOutputStream extends OutputStream {
    protected final OutputStream out;

    public ExceptionHandlingOutputStream(final OutputStream out) {
        this.out = out;
    }

    protected void handleException(final IOException e) throws IOException {
        throw e;
    }

    @Override
    public void close() throws IOException {
        try {
            out.close();
        } catch (IOException e) {
            handleException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            out.flush();
        } catch (IOException e) {
            handleException(e);
        }
    }

    @Override
    public void write(final byte[] b) throws IOException {
        try {
            out.write(b);
        } catch (IOException e) {
            handleException(e);
        }
    }

    @Override
    public void write(final byte[] b, final int off, final int len)
        throws IOException
    {
        try {
            out.write(b, off, len);
        } catch (IOException e) {
            handleException(e);
        }
    }

    @Override
    public void write(final int b) throws IOException {
        try {
            out.write(b);
        } catch (IOException e) {
            handleException(e);
        }
    }
}

