package ru.yandex.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FsyncingFileOutputStream extends FileOutputStream {
    private final int fsyncThreshold;
    private int written = 0;

    public FsyncingFileOutputStream(
        final File file,
        final boolean append,
        final int fsyncThreshold)
        throws FileNotFoundException
    {
        super(file, append);
        this.fsyncThreshold = fsyncThreshold;
    }

    private void fsync(final boolean metadata) throws IOException {
        getChannel().force(metadata);
    }

    private void written(final int count) throws IOException {
        written += count;
        if (written >= fsyncThreshold) {
            written = 0;
            fsync(false);
        }
    }

    @Override
    public void write(final int b) throws IOException {
        super.write(b);
        written(1);
    }

    @Override
    public void write(final byte[] b) throws IOException {
        super.write(b);
        written(b.length);
    }

    @Override
    public void write(
        final byte[] b,
        final int off,
        final int len)
        throws IOException
    {
        super.write(b, off, len);
        written(len);
    }
}
