package ru.yandex.io;

import java.io.Closeable;
import java.io.IOException;

import ru.yandex.function.GenericAutoCloseable;

public class GenericCloseableAdapter<T extends Closeable>
    implements GenericAutoCloseable<IOException>
{
    private final T t;

    public GenericCloseableAdapter(final T t) {
        this.t = t;
    }

    public T get() {
        return t;
    }

    @Override
    public void close() throws IOException {
        t.close();
    }
}

