package ru.yandex.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

import ru.yandex.util.string.HexStrings;

public class HexOutputStream extends OutputStream {
    private final Writer writer;
    private final char[] hex;

    public HexOutputStream(final Writer writer, final HexStrings hex) {
        this.writer = writer;
        this.hex = hex.chars();
    }

    @Override
    public void close() throws IOException {
        writer.close();
    }

    @Override
    public void flush() throws IOException {
        writer.flush();
    }

    @Override
    public void write(final byte[] buf) throws IOException {
        write(buf, 0, buf.length);
    }

    @Override
    public void write(final byte[] buf, final int off, final int len)
        throws IOException
    {
        for (int i = 0; i < len; ++i) {
            write(buf[i + off]);
        }
    }

    @Override
    public void write(final int b) throws IOException {
        writer.write(hex[(b >>> HexStrings.SHIFT) & HexStrings.MASK]);
        writer.write(hex[b & HexStrings.MASK]);
    }
}

