package ru.yandex.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamResetter implements Closeable {
    private final InputStream in;

    public InputStreamResetter(final InputStream in, final int len) {
        this.in = in;
        in.mark(len);
    }

    public InputStream in() {
        return in;
    }

    @Override
    public void close() throws IOException {
        in.reset();
    }
}
