package ru.yandex.io;

import java.io.IOException;
import java.io.InputStream;

public class LenientQuotedPrintableInputStream
    extends QuotedPrintableInputStream
{
    private boolean malformed = false;

    public LenientQuotedPrintableInputStream(final InputStream in) {
        super(in);
    }

    @Override
    protected void malformed(final int read, final int c1, final int c2) {
        malformed = true;
        buf[buflen++] = '=';
        if (c1 >= 0) {
            buf[buflen++] = (byte) c1;
            if (c2 >= 0) {
                buf[buflen++] = (byte) c2;
            }
        }
        while (pos < read) {
            buf[buflen++] = buf[pos++];
        }
    }

    @Override
    protected int doRead() throws IOException {
        return in.read(buf, 0, buf.length - 2);
    }

    @Override
    protected void fillBuffer() throws IOException {
        if (malformed) {
            buflen = in.read(buf);
            pos = 0;
        } else {
            super.fillBuffer();
        }
    }
}

