package ru.yandex.io;

import java.io.IOException;

import org.xml.sax.SAXException;

public class LimitedIOException extends IOException {
    private static final long serialVersionUID = 0L;

    public LimitedIOException() {
    }

    @Override
    @SuppressWarnings("UnsynchronizedOverridesSynchronized")
    public Throwable fillInStackTrace() {
        // Do nothing, this is just an execution flow controlling exception
        return this;
    }

    public static boolean isLimitedIOException(final Throwable t) {
        boolean result;
        if (t == null) {
            result = false;
        } else if (t instanceof LimitedIOException) {
            result = true;
        } else if (t instanceof SAXException) {
            result = isLimitedIOException(((SAXException) t).getException());
        } else {
            result = isLimitedIOException(t.getCause());
        }
        return result;
    }
}

