package ru.yandex.io;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream extends CountingInputStream {
    private final long limit;

    public LimitedInputStream(final InputStream in, final long limit) {
        super(in);
        this.limit = limit;
    }

    @Override
    public int available() throws IOException {
        return Math.min(
            super.available(),
            (int) Math.min(limit - pos, Integer.MAX_VALUE));
    }

    @Override
    public int read() throws IOException {
        if (pos < limit) {
            return super.read();
        } else {
            return -1;
        }
    }

    @Override
    public int read(final byte[] buf, final int off, final int len)
        throws IOException
    {
        long left = limit - pos;
        int toRead;
        if (left == 0L) {
            return -1;
        } else if (left < len) {
            toRead = (int) left;
        } else {
            toRead = len;
        }
        return super.read(buf, off, toRead);
    }
}

