package ru.yandex.io;

import java.io.IOException;
import java.io.OutputStream;

public class LimitedOutputStream extends CountingOutputStream {
    private final long limit;

    public LimitedOutputStream(final OutputStream out, final long limit) {
        super(out);
        this.limit = limit;
    }

    @Override
    public void write(final int b) throws IOException {
        if (pos >= limit) {
            throw new LimitedIOException();
        }
        super.write(b);
    }

    @Override
    public void write(final byte[] buf, final int off, final int len)
        throws IOException
    {
        long overrun = pos + len - limit;
        if (overrun > 0L) {
            super.write(buf, off, len - (int) overrun);
            throw new LimitedIOException();
        }
        super.write(buf, off, len);
    }
}

