package ru.yandex.io;

import java.io.IOException;
import java.io.Writer;

public class LimitedWriter extends Writer {
    private final Writer writer;
    private final long limit;
    private long pos = 0L;

    public LimitedWriter(final Writer writer, final long limit) {
        this.writer = writer;
        this.limit = limit;
    }

    @Override
    public void close() throws IOException {
        writer.close();
    }

    @Override
    public void flush() throws IOException {
        writer.flush();
    }

    @Override
    public void write(final char[] buf, final int off, final int len)
        throws IOException
    {
        long overrun = pos + len - limit;
        if (overrun > 0L) {
            writer.write(buf, off, len - (int) overrun);
            throw new LimitedIOException();
        }
        writer.write(buf, off, len);
        pos += len;
    }
}

