package ru.yandex.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;

import ru.yandex.function.ByteArrayVoidProcessor;

public class PathWriterProcessor
    implements ByteArrayVoidProcessor<IOException>
{
    private final Path path;

    public PathWriterProcessor(final Path path) {
        this.path = path;
    }

    @Override
    public void process(final byte[] buf, final int off, final int len)
        throws IOException
    {
        try (OutputStream out = Files.newOutputStream(path)) {
            out.write(buf, off, len);
        }
    }
}

