package ru.yandex.io;

import java.io.IOException;

import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.function.CharArrayVoidProcessor;

// Strict single line quoted-printable decoder, doesn't support soft line
// breaks, but replaces _ with space, as per rfc2047
public class QuotedPrintableDecoder
    extends ByteArrayProcessable
    implements CharArrayVoidProcessor<IOException>
{
    private static final int SHIFT = 4;
    private static final byte[] TABLE = {
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1,
        -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, 10, 11, 12, 13, 14, 15
    };
    private static final String AT_POS = "' at pos ";

    private static char charAt(final char[] cbuf, final int off, final int len)
        throws IOException
    {
        if (off >= len) {
            throw new MalformedQuotedPrintableException("EOF at pos " + off);
        }
        return cbuf[off];
    }

    @Override
    public void process(final char[] cbuf, final int off, final int len)
        throws IOException
    {
        ensureBufCapacity(len);
        this.len = 0;
        int end = len + off;
        int pos = off;
        while (pos < end) {
            char c = cbuf[pos];
            if (c > Byte.MAX_VALUE) {
                throw new MalformedQuotedPrintableException(
                    "Bad character '" + c + AT_POS + pos);
            }
            byte b;
            if (c == '=') {
                char c1 = charAt(cbuf, pos + 1, len);
                char c2 = charAt(cbuf, pos + 2, len);
                int upper;
                int lower;
                try {
                    upper = TABLE[c1];
                    lower = TABLE[c2];
                } catch (RuntimeException e) {
                    upper = -1;
                    lower = -1;
                }
                if (upper == -1 || lower == -1) {
                    throw new MalformedQuotedPrintableException(
                        "Malformed char codes after equal sign: '"
                        + c1 + '\'' + ',' + ' ' + '\'' + c2 + AT_POS + pos);
                }
                b = (byte) ((upper << SHIFT) + lower);
                pos += 2;
            } else if (c == '_') {
                b = ' ';
            } else {
                b = (byte) c;
            }
            buf[this.len++] = b;
            ++pos;
        }
    }
}

