package ru.yandex.io;

import java.io.PrintWriter;

public class StringBuilderWriter extends PrintWriter {
    private final StringBuilder sb;

    public StringBuilderWriter() {
        this(new StringBuilder());
    }

    public StringBuilderWriter(final StringBuilder sb) {
        super(new FakeWriter());
        this.sb = sb;
    }

    public void clear() {
        sb.setLength(0);
    }

    public StringBuilder sb() {
        return sb;
    }

    @Override
    public StringBuilderWriter append(final char c) {
        sb.append(c);
        return this;
    }

    @Override
    public StringBuilderWriter append(final CharSequence csq) {
        sb.append(csq);
        return this;
    }

    @Override
    public StringBuilderWriter append(
        final CharSequence csq,
        final int start,
        final int end)
    {
        sb.append(csq, start, end);
        return this;
    }

    @Override
    public boolean checkError() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void print(final boolean b) {
        sb.append(b);
    }

    @Override
    public void print(final char c) {
        sb.append(c);
    }

    @Override
    public void print(final char[] s) {
        sb.append(s);
    }

    @Override
    public void print(final double d) {
        sb.append(d);
    }

    @Override
    public void print(final float f) {
        sb.append(f);
    }

    @Override
    public void print(final int i) {
        sb.append(i);
    }

    @Override
    public void print(final long l) {
        sb.append(l);
    }

    @Override
    public void print(final Object obj) {
        sb.append(obj);
    }

    @Override
    public void print(final String s) {
        sb.append(s);
    }

    @Override
    public void println() {
        sb.append('\n');
    }

    @Override
    public void println(final boolean b) {
        sb.append(b);
        sb.append('\n');
    }

    @Override
    public void println(final char c) {
        sb.append(c);
        sb.append('\n');
    }

    @Override
    public void println(final char[] s) {
        sb.append(s);
        sb.append('\n');
    }

    @Override
    public void println(final double d) {
        sb.append(d);
        sb.append('\n');
    }

    @Override
    public void println(final float f) {
        sb.append(f);
        sb.append('\n');
    }

    @Override
    public void println(final int i) {
        sb.append(i);
        sb.append('\n');
    }

    @Override
    public void println(final long l) {
        sb.append(l);
        sb.append('\n');
    }

    @Override
    public void println(final Object obj) {
        sb.append(obj);
        sb.append('\n');
    }

    @Override
    public void println(final String s) {
        sb.append(s);
        sb.append('\n');
    }

    @Override
    public void write(final char[] cbuf) {
        sb.append(cbuf);
    }

    @Override
    public void write(final char[] cbuf, final int off, final int len) {
        sb.append(cbuf, off, len);
    }

    @Override
    public void write(final int c) {
        sb.append((char) c);
    }

    @Override
    public void write(final String str) {
        sb.append(str);
    }

    @Override
    public void write(final String str, final int off, final int len) {
        sb.append(str, off, len);
    }

    @Override
    public String toString() {
        return new String(sb);
    }

    private static class FakeWriter extends NullWriter {
    }
}

