package ru.yandex.io;

import java.io.IOException;
import java.io.Serializable;

public class TaggedIOException extends IOException {
    public static final long serialVersionUID = 0;

    private final Serializable tag;

    public TaggedIOException(
        final Serializable tag,
        final IOException cause)
    {
        super(cause);
        this.tag = tag;
    }

    public Serializable tag() {
        return tag;
    }

    @Override
    public IOException getCause() {
        return (IOException) super.getCause();
    }

    public static Serializable createTag() {
        return new FakeSerializable();
    }

    private static class FakeSerializable implements Serializable {
        private static final long serialVersionUID = 0;
    }
}

