package ru.yandex.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class TaggedInputStream extends InputStream {
    private final InputStream in;
    private final Serializable tag;

    public TaggedInputStream(final InputStream in) {
        this(in, TaggedIOException.createTag());
    }

    public TaggedInputStream(final InputStream in, final Serializable tag) {
        this.in = in;
        this.tag = tag;
    }

    @Override
    public int available() throws IOException {
        try {
            return in.available();
        } catch (IOException e) {
            throw new TaggedIOException(tag, e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            in.close();
        } catch (IOException e) {
            throw new TaggedIOException(tag, e);
        }
    }

    @Override
    public void mark(final int readLimit) {
        in.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return in.markSupported();
    }

    @Override
    public int read(final byte[] b) throws IOException {
        try {
            return in.read(b);
        } catch (IOException e) {
            throw new TaggedIOException(tag, e);
        }
    }

    @Override
    public int read(final byte[] b, final int off, final int len)
        throws IOException
    {
        try {
            return in.read(b, off, len);
        } catch (IOException e) {
            throw new TaggedIOException(tag, e);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return in.read();
        } catch (IOException e) {
            throw new TaggedIOException(tag, e);
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            in.reset();
        } catch (IOException e) {
            throw new TaggedIOException(tag, e);
        }
    }

    @Override
    public long skip(final long n) throws IOException {
        try {
            return in.skip(n);
        } catch (IOException e) {
            throw new TaggedIOException(tag, e);
        }
    }

    public boolean isCauseOf(final Exception e) {
        return e instanceof TaggedIOException
            && tag == ((TaggedIOException) e).tag();
    }

    public void throwIfCauseOf(final Exception e) throws IOException {
        if (e instanceof TaggedIOException) {
            TaggedIOException tagged = (TaggedIOException) e;
            if (tag == tagged.tag()) {
                throw tagged.getCause();
            }
        }
    }
}

