package ru.yandex.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class TaggedOutputStream extends ExceptionHandlingOutputStream {
    private final Serializable tag;

    public TaggedOutputStream(final OutputStream out) {
        this(out, TaggedIOException.createTag());
    }

    public TaggedOutputStream(final OutputStream out, final Serializable tag) {
        super(out);
        this.tag = tag;
    }

    public boolean isCauseOf(final IOException e) {
        return e instanceof TaggedIOException
            && tag == ((TaggedIOException) e).tag();
    }

    @Override
    protected void handleException(final IOException e) throws IOException {
        throw new TaggedIOException(tag, e);
    }
}

