package ru.yandex.io;

import java.io.IOException;
import java.io.Writer;

public class UnsafeStringBuilderWriter extends Writer {
    private StringBuilder sb;

    public UnsafeStringBuilderWriter() {
        this(new StringBuilder());
    }

    public UnsafeStringBuilderWriter(final StringBuilder sb) {
        super();
        this.sb = sb;
    }

    public StringBuilder sb() {
        return sb;
    }

    public UnsafeStringBuilderWriter sb(final StringBuilder sb) {
        this.sb = sb;
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(final char[] cbuf) {
        sb.append(cbuf);
    }

    @Override
    public void write(final char[] cbuf, final int off, final int len) {
        sb.append(cbuf, off, len);
    }

    @Override
    public void write(final int c) {
        sb.append((char) c);
    }

    @Override
    public void write(final String str) {
        sb.append(str);
    }

    @Override
    public void write(final String str, final int off, final int len) {
        sb.append(str, off, len);
    }

    @Override
    public String toString() {
        return new String(sb);
    }

    @Override
    public UnsafeStringBuilderWriter append(final char c) {
        sb.append(c);
        return this;
    }

    @Override
    public UnsafeStringBuilderWriter append(final CharSequence csq) {
        sb.append(csq);
        return this;
    }

    @Override
    public UnsafeStringBuilderWriter append(
        final CharSequence csq,
        final int start,
        final int end)
    {
        sb.append(csq, start, end);
        return this;
    }
}

