package ru.yandex.util.ip;

import java.io.File;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractIpListConfigBuilder
    <T extends AbstractIpListConfigBuilder<T>>
    implements IpListConfig, ConfigBuilder<T>
{
    private File file;

    protected AbstractIpListConfigBuilder(final IpListConfig config) {
        file(config.file());
    }

    protected AbstractIpListConfigBuilder(
        final IniConfig config,
        final IpListConfig defaults)
        throws ConfigException
    {
        file = FILE.extract(config, defaults.file());
    }

    @Override
    public File file() {
        return file;
    }

    public T file(final File file) {
        this.file = file;
        return self();
    }
}

