package ru.yandex.util.ip;

import java.io.File;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractIpRangeListConfigBuilder
    <T extends AbstractIpRangeListConfigBuilder<T>>
    implements IpRangeListConfig, ConfigBuilder<T>
{
    private File file;

    protected AbstractIpRangeListConfigBuilder(final IpRangeListConfig config) {
        file(config.file());
    }

    protected AbstractIpRangeListConfigBuilder(
        final IniConfig config,
        final IpRangeListConfig defaults)
        throws ConfigException
    {
        file = FILE.extract(config, defaults.file());
    }

    @Override
    public File file() {
        return file;
    }

    public T file(final File file) {
        this.file = file;
        return self();
    }
}

