package ru.yandex.util.ip;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class CidrListConfigBuilder
    extends AbstractCidrListConfigBuilder<CidrListConfigBuilder>
{
    public CidrListConfigBuilder() {
        super(CidrListConfigDefaults.INSTANCE);
    }

    public CidrListConfigBuilder(final CidrListConfig config) {
        super(config);
    }

    public CidrListConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, CidrListConfigDefaults.INSTANCE);
    }

    public CidrListConfigBuilder(
        final IniConfig config,
        final CidrListConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public CidrListConfigBuilder self() {
        return this;
    }

    public ImmutableCidrListConfig build() throws ConfigException {
        return new ImmutableCidrListConfig(this);
    }
}

